// myfilerd.cpp
#include <windows.h>
#include "myfilerd.h"

namespace mylib
{
CMyFileReader::CMyFileReader(const TCHAR* szName)
{
	m_hFile = ::CreateFile(szName, GENERIC_READ, FILE_SHARE_READ, 0,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if(m_hFile == INVALID_HANDLE_VALUE)
		return;
	Fill(m_bBuffer, MY_BUFSIZE, m_nFilled);
}

CMyFileReader::~CMyFileReader()
{
	if(m_hFile != INVALID_HANDLE_VALUE)
		::CloseHandle(m_hFile);
}

bool
CMyFileReader::Fill(unsigned char* buffer, size_t maxread, size_t& nread)
{
	DWORD dwRead = 0;
	if(!::ReadFile(m_hFile, buffer, maxread, &dwRead, 0))
	{
		nread = 0;
		return false;
	}
	nread = (size_t)dwRead;
	return true;
}

}	// namespace mylib
