// myscroll.h

#ifndef MYSCROLL_H_INCLUDED
#define MYSCROLL_H_INCLUDED

#include "mywin.h"

namespace mylib
{

class CMyScrollWin : public CMyWin
{
public:
	virtual ~CMyScrollWin();
	virtual void SetDrawSize(const POINT& ptOffset, const SIZE& sz);
	virtual int SetScrollInfo(int fnBar, SCROLLINFO* lpsi, BOOL fRedraw);
	virtual BOOL GetScrollInfo(int fnBar, SCROLLINFO* lpsi);
	virtual int Scroll(int dx, int dy, const RECT* prcScroll, const RECT* prcClip,
		HRGN hrgnUpdate, RECT* prcUpdate, UINT flags=0);

protected:
	CMyScrollWin();
	virtual BOOL Create(LPCTSTR szTitle, DWORD dwStyle,
		int x, int y, int nWidth, int nHeight,
		HWND hWndParent, HMENU hMenu);
	virtual BOOL OnSize(UINT nType, int cx, int cy);
	virtual BOOL OnHScroll(int nScrollCode, int nPos, HWND hwndScrollBar);
	virtual BOOL OnVScroll(int nScrollCode, int nPos, HWND hwndScrollBar);
	virtual BOOL OnMouseWheel(int fwKeys, int zDelta, int xPos, int yPos);

private:
	BOOL SetScrollParam();
	BOOL DeltaScroll(int nBarFlag, int zDelta);

protected:
	POINT m_ptOffset;
	SIZE m_szDraw;
	int m_xScrollUnit;
	int m_yScrollUnit;
};

}	// namespace mylib

#endif	// MYAPPWIN_H_INCLUDED
