// myreader.h
#ifndef MYREADER_H_INCLUDED
#define MYREADER_H_INCLUDED

namespace mylib
{
class CMyReader
{
public:
	virtual ~CMyReader();
	virtual bool Read(unsigned char* buffer, size_t maxread, size_t& nread);
	virtual int GetOctet();
	const unsigned char* Buffer() const;
	size_t Filled() const;
public:
	static const int MY_EOF = (-1);
	static const int MY_BUFSIZE = 1024;

protected:
	CMyReader();
	virtual bool Fill(unsigned char* buffer, size_t maxread, size_t& nread);

protected:
	bool m_bEofDetected;
	size_t m_nFilled;
	size_t m_nRead;
	unsigned char m_bBuffer[MY_BUFSIZE];
};

}	// namespace mylib
#endif	// MYREADER_H_INCLUDED
