#include <windows.h>
#include <tchar.h>
#include "resource.h"
#include "myapp.h"
#include "myappwin.h"
#include "myplain.h"
#include "mydjpeg.h"
#include "mybmp.h"
#include "myfilerd.h"

extern mylib::CMyApp* g_pApp;

namespace mylib
{
CMyApp::CMyApp(HINSTANCE hInstance, HINSTANCE hPrevInstance)
{
	// Save the instance handle
	m_hInstance = hInstance;

	// Load the main menu
	m_hMainMenu = LoadMenu(hInstance,MAKEINTRESOURCE(IDC_MY_MAINMENU));

	// Load the strings
	int nChar;
	nChar = LoadString(hInstance, IDS_MY_APPTITLE, m_szAppTitle, MAX_LOAD_STRING);
	m_szAppTitle[nChar] = 0;

	// Register the Window Class
	if(hPrevInstance == 0)
		CMyWin::Register(hInstance);
	ParseCommandLine();
}

CMyApp::~CMyApp()
{
	if(m_hMainMenu)
		DestroyMenu(m_hMainMenu);
}

int
CMyApp::Run(int nCmdShow)
{
	// Create Window
	CMyAppWin appwin(m_szAppTitle);

	// Create the document
	if(m_DocName.size() > 0)
	{
		std::vector<TCHAR>::const_iterator p = m_DocName.begin();
		GetDoc(&*p);
	}
	appwin.Show(nCmdShow);
	appwin.Update();

	POINT pt;
	pt.x = 0;
	pt.y = 0;
	HDC hdc = appwin.GetDC();
	SIZE sz = m_curDoc.Size(hdc);
	appwin.ReleaseDC(hdc);
	appwin.SetDrawSize(pt, sz);
	
	// Enter Message Loop
	MSG msg;
	while(GetMessage(&msg, 0, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return (int)msg.wParam;
}

BOOL
CMyApp::ParseCommandLine()
{
	const TCHAR* pCmdLine = GetCommandLine();
	if(pCmdLine == 0)
		return FALSE;

	// First argument (executable name)
	const TCHAR* p = pCmdLine;
	while(*p <= (TCHAR)' ')
	{
		if(*p == 0)
			return FALSE;
		++p;
	}
	TCHAR q = ' ';
	if((*p == '"') || (*p == '\''))
	{
		q = *p;
		++p;
	}
	while(*p != q)
	{
		if(*p == 0)
			return FALSE;
		++p;
	}
	++p;
	// Second argument
	while(*p <= (TCHAR)' ')
	{
		if(*p == 0)
			return FALSE;
		++p;
	}
	if((*p == '"') || (*p == '\''))
	{
		q = *p;
		++p;
	}
	std::vector<TCHAR> arg;
	while(*p != q)
	{
		if(*p == 0)
		{
			arg.push_back((TCHAR)0);
			m_DocName = arg;
			return TRUE;
		}
		arg.push_back(*p);
		++p;
	}
	arg.push_back((TCHAR)0);
	m_DocName = arg;
	return TRUE;
}

int
CMyApp::ContentType(const TCHAR* szName)
{
	int nType = CMyContent::TEXT_PLAIN;;
	int n = 0;
	while(szName[n] != 0)
		++n;
	if(n < 4)
		return nType;
	if(szName[n - 4] == '.')
	{
		if(((szName[n - 3] == 'b') || (szName[n - 3] == 'B')) &&
		  ((szName[n - 2] == 'm') || (szName[n - 2] == 'M')) &&
		  ((szName[n - 1] == 'p') || (szName[n - 1] == 'P')))
			nType = CMyContent::IMAGE_BMP;
		else if(((szName[n - 3] == 'j') || (szName[n - 3] == 'J')) &&
		  ((szName[n - 2] == 'p') || (szName[n - 2] == 'P')) &&
		  ((szName[n - 1] == 'g') || (szName[n - 1] == 'G')))
			nType = CMyContent::IMAGE_JPEG;
	}
	return nType;
}

BOOL
CMyApp::GetDoc(const TCHAR* szName)
{
	if(szName == 0)
		return FALSE;
	CMyFileReader* pReader = new CMyFileReader(szName);
	switch(ContentType(szName))
	{
	case CMyContent::TEXT_PLAIN:
		m_curDoc = CMyDoc((CMyContent*)(new CMyPlain((CMyReader*)pReader)));
		break;
	case CMyContent::IMAGE_JPEG:
		m_curDoc = CMyDoc((CMyContent*)(new CMyDjpeg((CMyReader*)pReader)));
		break;
	case CMyContent::IMAGE_BMP:
		m_curDoc = CMyDoc((CMyContent*)(new CMyBMP(szName)));
		break;
	default:
		break;
	}
	delete pReader;
	return TRUE;
}

}	// namespace mylib
