// mydoc.cpp

#include "mydoc.h"

namespace mylib
{

CMyDoc::CMyDoc() :
	m_pCounter(new int(1)), m_pContent(0)
{
}

CMyDoc::CMyDoc(CMyContent* pContent) :
	m_pCounter(new int(1)), m_pContent(pContent)
{
}

CMyDoc::CMyDoc(const CMyDoc& src) :
	m_pCounter(src.m_pCounter), m_pContent(src.m_pContent)
{
	(*m_pCounter)++;
}

CMyDoc::~CMyDoc()
{
	if(--(*m_pCounter) == 0)
	{
		delete m_pContent;
		delete m_pCounter;
	}
}

CMyDoc&
CMyDoc::operator=(const CMyDoc& src)
{
	if(m_pCounter == src.m_pCounter)
		return *this;

	if(--(*m_pCounter) == 0)
	{
		delete m_pContent;
		delete m_pCounter;
	}
	m_pContent = src.m_pContent;
	m_pCounter = src.m_pCounter;
	(*m_pCounter)++;
	return *this;
}

SIZE
CMyDoc::Size(HDC hdc)
{
	SIZE sz;
	if(m_pContent)
		sz = m_pContent->Size(hdc);
	else
	{
		sz.cx = 0;
		sz.cy = 0;
	}
	return sz;
}

int
CMyDoc::Draw(HDC hdc, int x, int y, PAINTSTRUCT& ps)
{
	int n;
	if(m_pContent)
		n = m_pContent->Draw(hdc, x, y, ps);
	else
		n = 0;
	return n;
}

} // namespace mylib
