// mydjpeg.h
#ifndef MYDJPEG_H_INCLUDED
#define MYDJPEG_H_INCLUDED

#include "myimage.h"

#include <stdio.h>
#define XMD_H
#define HAVE_BOOLEAN
#ifdef __cplusplus
extern "C"{
#endif
#include <jpeglib.h>
#include <jerror.h>
#ifdef __cplusplus
}
#endif

namespace mylib
{

class CMyDjpeg : public CMyImage
{
public:
	CMyDjpeg(const TCHAR* szDocName);
	virtual ~CMyDjpeg();

protected:
	class my_source_mgr
	{
	// Expanded data source object for our io input
	public:
		struct jpeg_source_mgr pub;	// public fields
		HANDLE hfile;		/* source stream */
		JOCTET * buffer;		/* start of buffer */
		bool start_of_file;	/* have we gotten any data yet? */
	};

typedef my_source_mgr* my_src_ptr;

private:
	static void init_source(j_decompress_ptr cinfo);
	static boolean fill_input_buffer(j_decompress_ptr cinfo);
	static void skip_input_data(j_decompress_ptr cinfo, long num_bytes);
	static void term_source (j_decompress_ptr cinfo);
	static void set_srcio(j_decompress_ptr cinfo, HANDLE hfile);
	static const int INPUT_BUF_SIZE = 4096;

private:
	bool ReadFile(const TCHAR* szFilename);
	bool Prepare(int width, int height, int numcomp);
	bool FillImage(int lineno, JOCTET* buffer, int nlen);

protected:
	int m_width;
	int m_height;
	int m_numcomponents;
	int m_dispcomponents;
	size_t m_linelength;
	BITMAPINFO m_bmi;
	BYTE* m_lpFileData;
};

}	// namespace mylib

#endif	// MYDJPEG_H_INCLUDED
