// myappwin.cpp

#include "resource.h"
#include "myappwin.h"
#include "myapp.h"


extern mylib::CMyApp* g_pApp;

namespace mylib
{

CMyAppWin::CMyAppWin(LPCTSTR szTitle)
{
	Create(szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, 0, g_pApp->m_hMainMenu);
}

BOOL
CMyAppWin::ReDraw()
{
	POINT pt;
	pt.x = 0;
	pt.y = 0;
	HDC hdc = GetDC();
	SIZE sz = g_pApp->m_curDoc.Size(hdc);
	ReleaseDC(hdc);
	SetDrawSize(pt, sz);
	InvalidateRect();
	Update();
	return TRUE;
}

BOOL
CMyAppWin::OnDestroy()
{
	PostQuitMessage(0);
	return TRUE;
}

BOOL
CMyAppWin::OnPaint()
{
	PAINTSTRUCT ps;
	HDC hdc = CMyWin::BeginPaint(&ps);
	g_pApp->m_curDoc.Draw(hdc, -m_ptOffset.x, -m_ptOffset.y, ps);
	CMyWin::EndPaint(&ps);
	return TRUE;
}

BOOL
CMyAppWin::OnCommand(WPARAM wParam, LPARAM lParam)
{
	int wmId = LOWORD(wParam);
//	int wmEvent = HIWORD(wParam);
	switch(wmId)
	{
	case IDM_FILE_OPEN:
		if(g_pApp->m_ofnOpen.GetOpenFileName())
		{
			g_pApp->GetDoc(g_pApp->m_ofnOpen.FileName());
			ReDraw();
		}
		break;
	case IDM_FILE_EXIT:
		Destroy();
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

}	// namespace mylib
