// myapp.h

#ifndef MYAPP_H_INCLUDED
#define MYAPP_H_INCLUDED

#include <vector>
#include "mydoc.h"
#include "myofn.h"

namespace mylib
{

class CMyApp
{
private:
	static const int MAX_LOAD_STRING = 256;
	static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

public:
	CMyApp(HINSTANCE hInstance, HINSTANCE hPrevInstance);
	~CMyApp();
	int Run(int nCmdShow);
	BOOL GetDoc(const TCHAR* szName);

public:
	HINSTANCE m_hInstance;
	HMENU m_hMainMenu;
	CMyDoc m_curDoc;
	CMyOfn m_ofnOpen;
	CMyOfn m_ofnSave;

private:
	BOOL ParseCommandLine();
	int ContentType(const TCHAR* szName);

private:
	std::vector<TCHAR> m_DocName;
	TCHAR m_szAppTitle[(MAX_LOAD_STRING+1)];
};
}	// namespace mylib
#endif	// MYAPP_H_INCLUDED
