// myappwin.cpp

#include "resource.h"
#include "myappwin.h"
#include "myapp.h"


extern mylib::CMyApp* g_pApp;

namespace mylib
{

CMyAppWin::CMyAppWin(LPCTSTR szTitle)
{
	Create(szTitle, WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, 0, g_pApp->m_hMainMenu);
}

BOOL
CMyAppWin::OnDestroy()
{
	PostQuitMessage(0);
	return TRUE;
}

BOOL
CMyAppWin::OnPaint()
{
	PAINTSTRUCT ps;
	HDC hdc = CMyWin::BeginPaint(&ps);
	g_pApp->m_curDoc.Draw(hdc, -m_ptOffset.x, -m_ptOffset.y, ps);
	CMyWin::EndPaint(&ps);
	return TRUE;
}

BOOL
CMyAppWin::OnCommand(WPARAM wParam, LPARAM lParam)
{
	int wmId = LOWORD(wParam);
//	int wmEvent = HIWORD(wParam);
	switch(wmId)
	{
	case IDM_FILE_EXIT:
		Destroy();
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

}	// namespace mylib
