// mybmp.cpp

#include "mybmp.h"

namespace mylib
{

CMyBMP::CMyBMP(const TCHAR* lpFileName)
{
	m_lpFileData = 0;

	// Content variables
	//
	// BYTE* m_lpFileData;
	// BITMAPINFO* m_lpbmi;
	// BYTE* m_lpvBits;

	HANDLE hFile;
	DWORD dwSize;
	DWORD dwRead;
	DWORD dwHead;
	BITMAPFILEHEADER* lpbmfh;

	if((hFile = CreateFile(lpFileName, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING,
		FILE_ATTRIBUTE_READONLY, 0)) == INVALID_HANDLE_VALUE)
		return;
	if((dwSize = GetFileSize(hFile,0)) == 0xffffffff)
	{
		CloseHandle(hFile);
		return;
	}
	m_lpbmi = 0;
	m_lpvBits = 0;
	delete [] m_lpFileData;
	m_lpFileData = new BYTE [dwSize];
	if(m_lpFileData == 0)
	{
		CloseHandle(hFile);
		return;
	}
	if(!ReadFile(hFile, m_lpFileData, dwSize, &dwRead, 0))
	{
		delete [] m_lpFileData;
		m_lpFileData = 0;
		CloseHandle(hFile);
		return;
	}
	CloseHandle(hFile);
	lpbmfh = (BITMAPFILEHEADER*)m_lpFileData;
	dwHead = sizeof(BITMAPFILEHEADER);
	m_lpvBits = (BYTE*)&m_lpFileData[lpbmfh->bfOffBits];
	m_lpbmi = (BITMAPINFO*)&m_lpFileData[dwHead];
	return;
}

CMyBMP::~CMyBMP()
{
	delete [] m_lpFileData;
}

}	// namespace mylib
