// myimage.cpp

#include "myimage.h"

namespace mylib
{

CMyImage::CMyImage()
{
	m_lpbmi = 0;
	m_lpvBits = 0;
}

CMyImage::~CMyImage()
{
}

int
CMyImage::Draw(HDC hdc, int x, int y, PAINTSTRUCT& ps)
{
	if(m_lpbmi && m_lpvBits)
	{
		SetDIBitsToDevice(hdc, x, y,
			m_lpbmi->bmiHeader.biWidth, m_lpbmi->bmiHeader.biHeight, 0, 0,
			0, m_lpbmi->bmiHeader.biHeight, m_lpvBits, m_lpbmi, DIB_RGB_COLORS);
	}
	return 0;
}

const SIZE&
CMyImage::Size(HDC hdc)
{
	if(m_lpbmi && m_lpvBits)
	{
		m_sz.cx = m_lpbmi->bmiHeader.biWidth;
		if(m_sz.cx < 0)
			m_sz.cx = -m_sz.cx;
		m_sz.cy = m_lpbmi->bmiHeader.biHeight;
		if(m_sz.cy < 0)
			m_sz.cy = -m_sz.cy;
	}
	else
	{
		m_sz.cx = 1;
		m_sz.cy = 1;
	}
	return m_sz;
}

}	// namespace mylib
