// mydjpeg.cpp

#include "mydjpeg.h"

namespace mylib
{

CMyDjpeg::CMyDjpeg(const TCHAR* lpFileName)
{
	::ZeroMemory(&m_bmi,sizeof(BITMAPINFO));
	m_lpvBits = 0;
	m_lpbmi = &m_bmi;
	m_width = 0;
	m_height = 0;
	m_numcomponents = 0;
	m_dispcomponents = 3;
	m_linelength = 0;
	ReadFile(lpFileName);
	return;
}

CMyDjpeg::~CMyDjpeg()
{
	delete [] m_lpvBits;
}

bool
CMyDjpeg::Prepare(int width, int height, int numcomp)
{
	::ZeroMemory(&m_bmi,sizeof(BITMAPINFO));
	delete [] m_lpvBits;
	m_lpvBits = 0;

	size_t n = ((width * m_dispcomponents + sizeof(LONG) - 1) / sizeof(LONG)) * sizeof(LONG);
	size_t nsize = n * height;
	if( nsize == 0 )
		return false;

	m_lpvBits = new BYTE [nsize];

	m_width = width;
	m_height = height;
	m_numcomponents = numcomp;
	m_linelength = n;

	m_bmi.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
	m_bmi.bmiHeader.biWidth       = width;
	m_bmi.bmiHeader.biHeight      = height;
	m_bmi.bmiHeader.biPlanes      = 1;
	m_bmi.bmiHeader.biBitCount    = m_dispcomponents * 8;
	m_bmi.bmiHeader.biCompression = BI_RGB;
	m_bmi.bmiHeader.biSizeImage   = (DWORD)nsize;

	return true;
}

bool
CMyDjpeg::FillImage(int lineno, JOCTET* buffer, int nlen)
{
	if((m_lpvBits == 0) || (buffer == 0))
		return false;

	if(m_numcomponents == 3)
	{
		int k = (int)m_linelength * lineno;
		for(int i = 0; i < m_width; i++)
		{
			int j = i * m_dispcomponents;
			m_lpvBits[k + j + 0] = (BYTE)buffer[j + 2];
			m_lpvBits[k + j + 1] = (BYTE)buffer[j + 1];
			m_lpvBits[k + j + 2] = (BYTE)buffer[j + 0];
		}
	}
	else if(m_numcomponents == 1)
	{
		int k = (int)m_linelength * lineno;
		for(int i = 0; i < m_width; i++)
		{
			int j = i * m_dispcomponents;
			m_lpvBits[k + j + 0] = (BYTE)buffer[i];
			m_lpvBits[k + j + 1] = (BYTE)buffer[i];
			m_lpvBits[k + j + 2] = (BYTE)buffer[i];
		}
	}
	else
	{
		for(int i = 0; i < nlen; i++)
			m_lpvBits[lineno * m_linelength + i] = (BYTE)buffer[i];
	}
	return true;
}

/*
 * Initialize source --- called by jpeg_read_header
 * before any data is actually read.
 */

void
CMyDjpeg::init_source(j_decompress_ptr cinfo)
{
	my_src_ptr src = (my_src_ptr) cinfo->src;

	/* We reset the empty-input-file flag for each image,
	 * but we don't clear the input buffer.
	 * This is correct behavior for reading a series of images from one source.
	 */
	src->start_of_file = TRUE;
}

/*
 * Fill the input buffer --- called whenever buffer is emptied.
 *
 * In typical applications, this should read fresh data into the buffer
 * (ignoring the current state of next_input_byte & bytes_in_buffer),
 * reset the pointer & count to the start of the buffer, and return TRUE
 * indicating that the buffer has been reloaded.  It is not necessary to
 * fill the buffer entirely, only to obtain at least one more byte.
 *
 * There is no such thing as an EOF return.  If the end of the file has been
 * reached, the routine has a choice of ERREXIT() or inserting fake data into
 * the buffer.  In most cases, generating a warning message and inserting a
 * fake EOI marker is the best course of action --- this will allow the
 * decompressor to output however much of the image is there.  However,
 * the resulting error message is misleading if the real problem is an empty
 * input file, so we handle that case specially.
 *
 * In applications that need to be able to suspend compression due to input
 * not being available yet, a FALSE return indicates that no more data can be
 * obtained right now, but more may be forthcoming later.  In this situation,
 * the decompressor will return to its caller (with an indication of the
 * number of scanlines it has read, if any).  The application should resume
 * decompression after it has loaded more data into the input buffer.  Note
 * that there are substantial restrictions on the use of suspension --- see
 * the documentation.
 *
 * When suspending, the decompressor will back up to a convenient restart point
 * (typically the start of the current MCU). next_input_byte & bytes_in_buffer
 * indicate where the restart point will be if the current call returns FALSE.
 * Data beyond this point must be rescanned after resumption, so move it to
 * the front of the buffer rather than discarding it.
 */

boolean
CMyDjpeg::fill_input_buffer (j_decompress_ptr cinfo)
{
	my_src_ptr src = (my_src_ptr) cinfo->src;
	size_t nbytes;

	//  nbytes = JFREAD(src->infile, src->buffer, INPUT_BUF_SIZE);
	if(!::ReadFile(src->hfile, src->buffer, INPUT_BUF_SIZE, (DWORD*)&nbytes, 0))
		return FALSE;

	if (nbytes <= 0) {
//@		if (src->start_of_file)	/* Treat empty input file as fatal error */
//@			ERREXIT(cinfo, JERR_INPUT_EMPTY);
//@		WARNMS(cinfo, JWRN_JPEG_EOF);
		/* Insert a fake EOI marker */
		src->buffer[0] = (JOCTET) 0xFF;
		src->buffer[1] = (JOCTET) JPEG_EOI;
		nbytes = 2;
	}

	src->pub.next_input_byte = src->buffer;
	src->pub.bytes_in_buffer = nbytes;
	src->start_of_file = FALSE;

	return TRUE;
}

/*
 * Skip data --- used to skip over a potentially large amount of
 * uninteresting data (such as an APPn marker).
 *
 * Writers of suspendable-input applications must note that skip_input_data
 * is not granted the right to give a suspension return.  If the skip extends
 * beyond the data currently in the buffer, the buffer can be marked empty so
 * that the next read will cause a fill_input_buffer call that can suspend.
 * Arranging for additional bytes to be discarded before reloading the input
 * buffer is the application writer's problem.
 */

void
CMyDjpeg::skip_input_data (j_decompress_ptr cinfo, long num_bytes)
{
	my_src_ptr src = (my_src_ptr) cinfo->src;

	/* Just a dumb implementation for now.  Could use fseek() except
	 * it doesn't work on pipes.  Not clear that being smart is worth
	 * any trouble anyway --- large skips are infrequent.
	 */
	if (num_bytes > 0) {
		while (num_bytes > (long) src->pub.bytes_in_buffer) {
			num_bytes -= (long) src->pub.bytes_in_buffer;
			(void) fill_input_buffer(cinfo);
			/* note we assume that fill_input_buffer will never return FALSE,
			 * so suspension need not be handled.
			 */
		}
		src->pub.next_input_byte += (size_t) num_bytes;
		src->pub.bytes_in_buffer -= (size_t) num_bytes;
	}
}

/*
 * An additional method that can be provided by data source modules is the
 * resync_to_restart method for error recovery in the presence of RST markers.
 * For the moment, this source module just uses the default resync method
 * provided by the JPEG library.  That method assumes that no backtracking
 * is possible.
 */


/*
 * Terminate source --- called by jpeg_finish_decompress
 * after all data has been read.  Often a no-op.
 *
 * NB: *not* called by jpeg_abort or jpeg_destroy; surrounding
 * application must deal with any cleanup that should happen even
 * for error exit.
 */

void
CMyDjpeg::term_source (j_decompress_ptr cinfo)
{
	/* no work necessary here */
}

void
CMyDjpeg::set_srcio(j_decompress_ptr cinfo, HANDLE hfile)
{
	my_src_ptr src;

	/* The source object and input buffer are made permanent so that a series
	 * of JPEG images can be read from the same file by calling jpeg_stdio_src
	 * only before the first one.  (If we discarded the buffer at the end of
	 * one image, we'd likely lose the start of the next one.)
	 * This makes it unsafe to use this manager and a different source
	 * manager serially with the same JPEG object.  Caveat programmer.
	 */
	if (cinfo->src == NULL) {	/* first time for this JPEG object? */
		cinfo->src = (struct jpeg_source_mgr *)
			(*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
				sizeof(my_source_mgr));
		src = (my_src_ptr) cinfo->src;
		src->buffer = (JOCTET *)
			(*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_PERMANENT,
				INPUT_BUF_SIZE * sizeof(JOCTET));
	}

	src = (my_src_ptr) cinfo->src;
	src->pub.init_source = init_source;
	src->pub.fill_input_buffer = fill_input_buffer;
	src->pub.skip_input_data = skip_input_data;
	src->pub.resync_to_restart = jpeg_resync_to_restart; /* use default method */
	src->pub.term_source = term_source;
	src->hfile = hfile;
	src->pub.bytes_in_buffer = 0; /* forces fill_input_buffer on first read */
	src->pub.next_input_byte = NULL; /* until buffer loaded */
}

bool
CMyDjpeg::ReadFile(const TCHAR* szFilename)
{
	if(szFilename == 0)
		return false;

	struct jpeg_error_mgr jerr;
	struct jpeg_decompress_struct cinfo;
	HANDLE hfile;		/* source file */
	JSAMPARRAY buffer;		/* Output row buffer */
	int row_stride;		/* physical row width in output buffer */

	hfile = ::CreateFile(szFilename, GENERIC_READ, FILE_SHARE_READ, 0,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
	if(hfile == INVALID_HANDLE_VALUE)
		return false;

	// We set up the normal JPEG error routines, then override error_exit. */
	cinfo.err = jpeg_std_error(&jerr);

	// Step 1: allocate and initialize JPEG decompression object

	// Now we can initialize the JPEG decompression object.
	jpeg_create_decompress(&cinfo);

	// Step 2: specify data source (eg, a file)
	set_srcio(&cinfo, hfile);

	// Step 3: read file parameters with jpeg_read_header()

	(void) jpeg_read_header(&cinfo, TRUE);
	// We can ignore the return value from jpeg_read_header since
	//  (a) suspension is not possible with the stdio data source, and
	//  (b) we passed TRUE to reject a tables-only JPEG file as an error.
	// See libjpeg.doc for more info.
	
	// Step 4: set parameters for decompression
	
	// In this example, we don't need to change any of the defaults set by
	// jpeg_read_header(), so we do nothing here.

	// Step 5: Start decompressor

	(void) jpeg_start_decompress(&cinfo);
	// We can ignore the return value since suspension is not possible
	// with the stdio data source.

	// We may need to do some setup of our own at this point before reading
	// the data.  After jpeg_start_decompress() we have the correct scaled
	// output image dimensions available, as well as the output colormap
	// if we asked for color quantization.
	// In this example, we need to make an output work buffer of the right size.

	// JSAMPLEs per row in output buffer
	row_stride = cinfo.output_width * cinfo.output_components;

	// Make a one-row-high sample array that will go away when done with image
	buffer = (*cinfo.mem->alloc_sarray)
		((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
	Prepare(cinfo.output_width, cinfo.output_height, cinfo.output_components);

	// Step 6: while (scan lines remain to be read)
	//           jpeg_read_scanlines(...);
	
	// Here we use the library's state variable cinfo.output_scanline as the
	// loop counter, so that we don't have to keep track ourselves.
	while (cinfo.output_scanline < cinfo.output_height)
	{
		// jpeg_read_scanlines expects an array of pointers to scanlines.
		// Here the array is only one element long, but you could ask for
		// more than one scanline at a time if that's more convenient.
		(void) jpeg_read_scanlines(&cinfo, buffer, 1);
		// Assume put_scanline_someplace wants a pointer and sample count.
		// put_scanline_someplace(buffer[0], row_stride);
		int lineno = cinfo.output_height - cinfo.output_scanline;
		FillImage(lineno, buffer[0], row_stride);
	}

	// Step 7: Finish decompression
	
	(void) jpeg_finish_decompress(&cinfo);
	// We can ignore the return value since suspension is not possible
	// with the stdio data source.

	// Step 8: Release JPEG decompression object

	// This is an important step since it will release a good deal of memory.
	jpeg_destroy_decompress(&cinfo);

	// After finish_decompress, we can close the input file.
	// Here we postpone it until after no more JPEG errors are possible,
	// so as to simplify the setjmp error logic above.  (Actually, I don't
	// think that jpeg_destroy can do an error exit, but why assume anything...)

	::CloseHandle(hfile);

	return true;
}

}	// namespace mylib
