// mywin.h

#ifndef MYWIN_H_INCLUDED
#define MYWIN_H_INCLUDED

#include <windows.h>

namespace mylib
{

class CMyWin
{
public:
	static BOOL Register(HINSTANCE hInstance);

private:
	static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
	static const int MAX_LOAD_STRING = 128;
	static TCHAR m_szClassName[(MAX_LOAD_STRING+1)];
	static HINSTANCE m_hInstance;

public:
	virtual ~CMyWin();
	virtual BOOL Create(LPCTSTR szTitle, DWORD dwStyle,
		int x, int y, int nWidth, int nHeight,
		HWND hWndParent, HMENU hMenu);
	virtual BOOL Destroy();
	BOOL Show(int nCmdShow = SW_SHOW);
	BOOL Update();
	HDC GetDC();
	int ReleaseDC(HDC hdc);
	HDC BeginPaint(PAINTSTRUCT* lpPaint);
	BOOL EndPaint(const PAINTSTRUCT* lpPaint);
	BOOL GetClientRect(LPRECT lpRect);
	BOOL GetWindowRect(LPRECT lpRect);

protected:
	CMyWin();
	virtual BOOL OnCreate();
	virtual BOOL OnDestroy();
	virtual BOOL OnPaint();
	virtual BOOL OnSize(UINT nType, int cx, int cy);
	virtual BOOL OnHScroll(int nScrollCode, int nPos, HWND hwndScrollBar);
	virtual BOOL OnVScroll(int nScrollCode, int nPos, HWND hwndScrollBar);
	virtual BOOL OnMouseWheel(int fwKeys, int zDelta, int xPos, int yPos);

protected:
	HWND m_hWnd;
};

}	// namespace mylib
#endif	// MYWIN_H_INCLUDED
