// mywin.h

#ifndef MYWIN_H_INCLUDED
#define MYWIN_H_INCLUDED

#include <windows.h>

namespace mylib
{

class CMyWin
{
public:
	static BOOL Register(HINSTANCE hInstance);

private:
	static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
	static const int MAX_LOAD_STRING = 128;
	static TCHAR m_szClassName[(MAX_LOAD_STRING+1)];
	static HINSTANCE m_hInstance;

public:
	virtual ~CMyWin();
	BOOL Create(LPCTSTR szTitle, DWORD dwStyle,
		int x, int y, int nWidth, int nHeight,
		HWND hWndParent, HMENU hMenu);
	BOOL Show(int nCmdShow = SW_SHOW);
	BOOL Update();
	HDC BeginPaint(PAINTSTRUCT* lpPaint);
	BOOL EndPaint(const PAINTSTRUCT* lpPaint);

protected:
	CMyWin();
	virtual BOOL OnCreate();
	virtual BOOL OnDestroy();
	virtual BOOL OnPaint();

protected:
	HWND m_hWnd;
};

}	// namespace mylib
#endif	// MYWIN_H_INCLUDED
