// myplain.cpp

#include "myplain.h"

namespace mylib
{

CMyPlain::CMyPlain()
{
}

CMyPlain::CMyPlain(const TCHAR* pszFileName)
{
	HANDLE hFile = CreateFile(pszFileName, GENERIC_READ, FILE_SHARE_READ, 0,
		OPEN_EXISTING, FILE_ATTRIBUTE_READONLY, 0);

	if(hFile == INVALID_HANDLE_VALUE)
		return;

	DWORD nRead = 0;
	unsigned char buf[2];
	while(1)
	{
		std::vector<TCHAR> linebuf;
		while(ReadFile(hFile, buf, 1, &nRead, 0))
		{
			if((nRead == 0) || (buf[0] == '\n'))
			{
				m_linebuf.push_back(linebuf);
				break;
			}
			if(buf[0] > ' ')
				linebuf.push_back((TCHAR)buf[0]);
			else
				linebuf.push_back((TCHAR)' ');
		}
		if(nRead == 0)
		{
			CloseHandle(hFile);
			return;
		}
	}
	CloseHandle(hFile);
}

CMyPlain::~CMyPlain()
{
}

int
CMyPlain::Draw(HDC hdc, int x, int y, PAINTSTRUCT& ps)
{
	TEXTMETRIC tm;
	GetTextMetrics(hdc, &tm);
	int ystep = (int)(tm.tmHeight + tm.tmExternalLeading);
	std::vector<std::vector<TCHAR> >::iterator p = m_linebuf.begin();
	while(p != m_linebuf.end() )
	{
		if(p->size() > 0)
		{
			std::vector<TCHAR>::iterator q = p->begin();
			TextOut(hdc, x, y, &*q, p->size());
		}
		p++;
		y += ystep;
	}
	return 0;
}

}	// namespace mylib
