/* Check program */

#include <stdio.h>
#include <stdlib.h>
#include "Packet.h"
#include "ErrCode.h"

#define FNAME	"1check_N"
#define N_TM	20
#define	REPEAT	1

#define BUF_SIZE	16000

//------Error String------
char* pszErrString[] =
{
/*	0	*/	"\t\x1b[34m....Done with No-problems....\x1b[0m\n",
/*	1	*/	"\x1b[33mYou should be 'root' to run this program.\x1b[0m\n",

/*	2	*/	"\x1b[33mThere are no Space to store data.\x1b[0m\n",
/*	3	*/	"\x1b[33mExecution faild...\x1b[0m\n",
/*	4	*/	"\x1b[33mComparison faild\x1b[0m\n",

/*	5	*/	"\x1b[33mThis Chcek rootin FAILED.....\x1b[0m\n",
/*	4	*/	"\x1b[33mRx Timeout occured.\x1b[0m\n"
};
//------function prototype------
int MyProc(int nArg);


//=======================================
int main(int argc, char *argv[])
{
	int nErr;
	int nArg = N_TM;

	//-----<argument>-----
	if ( argc==2 )	nArg = atoi(argv[1]);
	
	//-----<operation>-----
	nErr = MyProc(nArg);
	
	//-----<operation result>-----
	puts(FNAME);
	printf( pszErrString[nErr] );
	
	return nErr;
}

//=======================================
int MyProc(int nArg)
{
	int nErr=0;

	CPacket pkt_NScan(BUF_SIZE);
	
//==================<Command Frame Set>========================
	//-----N-scan check----
puts("N-scan Frames set!");
	unsigned char N;
	unsigned char wcnt=0;

for ( wcnt=0; wcnt<REPEAT; wcnt++ )
{
	for ( N=1; N<24; N++ )
	{
		if
		(
			pkt_NScan.AddFrame(N,0,0,0)	||	//Set N=1..23
			pkt_NScan.AddFrame(nArg,0,1,0)		//dataway read
		)
		return 2;
	}
}

//puts("Cycle Go!");
	unsigned long er;
	if ( er=pkt_NScan.Go() )
	{
		printf("er=%d\n",er);
		return 3;
	}
//==================<Comparison!>========================
unsigned long i;
unsigned long code, data;
unsigned long ErrAmount=0;
char szMsg[0xFF];
struct DATAWAYSTAT dataway;
//-------
puts("N scan compare...");
	unsigned char sentN;
	
	i=0;
	while ( pkt_NScan.ReadFrame(i,&code, &data)==0 )
	{
		memset( szMsg, 0x00, sizeof(szMsg) );
		sprintf( szMsg, "%d\tCHECK :\t0x%08x\t0x%08x\n", i, code, data);

		sentN = (code & 0x00FF0000)>>16;
		i++;
		pkt_NScan.ReadFrame(i,&code, &data);

		sprintf(szMsg+strlen(szMsg), "%d\tREAD :\t0x%08x\t0x%08x\n", i, code, data);

		DecTM(&dataway, data);
		i++;
		
		if ( sentN != dataway.N )
		{
			create_logfile(FNAME, szMsg);
			ErrAmount++;
		}
	}
//-------


	if ( ErrAmount )	return 4;
	
	return nErr;
}

