/* Check program */

#include <stdio.h>
#include <stdlib.h>
#include "Packet.h"
#include "ErrCode.h"

#define FNAME	"3check_F"
#define N_TM	20
#define REPEAT	1

#define BUF_SIZE	16000

//------Error String------
char* pszErrString[] =
{
/*	0	*/	"\t\x1b[34m....Done with No-problems....\x1b[0m\n",
/*	1	*/	"\x1b[33mYou should be 'root' to run this program.\x1b[0m\n",

/*	2	*/	"\x1b[33mThere are no Space to store data.\x1b[0m\n",
/*	3	*/	"\x1b[33mExecution faild...\x1b[0m\n",
/*	4	*/	"\x1b[33mComparison faild\x1b[0m\n",

/*	5	*/	"\x1b[33mThis Chcek rootin FAILED.....\x1b[0m\n",
/*	4	*/	"\x1b[33mRx Timeout occured.\x1b[0m\n"
};
//------function prototype------
int MyProc(int nArg);


//=======================================
int main(int argc, char *argv[])
{
	int nErr;
	int nArg = N_TM;

	//-----<argument>-----
	if ( argc==2 )	nArg = atoi(argv[1]);
	
	//-----<operation>-----
	nErr = MyProc(nArg);
	
	//-----<operation result>-----
	puts(FNAME);
	printf( pszErrString[nErr] );
	
	return nErr;
}

//=======================================
int MyProc(int nArg)
{
	int nErr=0;

	CPacket pkt_FScan(BUF_SIZE);
	
//==================<Command Frame Set>========================
	//-----F-scan check----
puts("F-scan Frames set!");
	unsigned char F;
	unsigned char wcnt=0;

for ( wcnt=0; wcnt<REPEAT; wcnt++ )
{
	for ( F=0; F<32; F++ )
	{
		if
		(
			pkt_FScan.AddFrame(nArg,0,F,0)	||	//Set F=0..31
			pkt_FScan.AddFrame(nArg,0,1,0)		//dataway read
		)
		return 2;
	}
}

//puts("Cycle Go!");
	unsigned long er;
	if ( er=pkt_FScan.Go() )
	{
		printf("er=%d\n",er);
		return 3;
	}
//==================<Comparison!>========================
unsigned long i;
unsigned long code, data;
unsigned long ErrAmount=0;
char szMsg[0xFF];
struct DATAWAYSTAT dataway;
//-------
puts("F scan compare...");
	unsigned char sentF;
	
	i=0;
	while ( pkt_FScan.ReadFrame(i,&code, &data)==0 )
	{
		memset( szMsg, 0x00, sizeof(szMsg) );
		sprintf( szMsg, "%d\tCHECK :\t0x%08x\t0x%08x\n", i, code, data);

		sentF = (code & 0x000000FF);
		i++;
		pkt_FScan.ReadFrame(i,&code, &data);

		sprintf(szMsg+strlen(szMsg), "%d\tREAD :\t0x%08x\t0x%08x\n", i, code, data);

		DecTM(&dataway, data);
		i++;
		
		if ( sentF != dataway.F )
		{
			create_logfile(FNAME, szMsg);
			ErrAmount++;
		}
	}
//-------


	if ( ErrAmount )	return 4;
	
	return nErr;
}

