/* Data packet class */

#include	<stdio.h>
#include    "ccnet_io.h"
#include	"ErrCode.h"



//===========================================================================
//-----------PCI register handling class definition---------
class CPCIreg
{
public:
	//---constructor & destructor---
	CPCIreg();
	~CPCIreg();
	
	//----Show PCI reg. val.
	static int Dump();
	
	//----Show FIFO status
	static int ShowFiFoStat();
	
	//----Clear FIFO
	static int ClearFiFo();


private:

};





//===========================================================================
//-----------PCIreg handling class body---------
CPCIreg::CPCIreg()
{
}

CPCIreg::~CPCIreg()
{
}


//----Show PCI reg. val.
int CPCIreg::Dump()
{
	struct PCIREG reg;
	if ( dump_reg(&reg) ) return -1;

		puts("");
		printf("Tx Control reg.\t\t0x%04x 0x%04x\n", reg.txctl_u, reg.txctl_l );
		printf("Tx Status reg.\t\t0x%04x 0x%04x\n", reg.txsta_u, reg.txsta_l );
		printf("Tx Master Mode addr.\t0x%04x 0x%04x\n", reg.txmar_u, reg.txmar_l );
		printf("Tx Frame Preset cnt.\t0x%04x 0x%04x\n", reg.txfpr_u, reg.txfpr_l );
		printf("Tx Frame Count reg.\t0x%04x 0x%04x\n", reg.txfcr_u, reg.txfcr_l );
		printf("Tx FIFO Counter\t\t0x%04x 0x%04x\n", reg.txcnt_u, reg.txcnt_l );
	
		puts("");
		printf("Rx Control reg.\t\t0x%04x 0x%04x\n", reg.rxctl_u, reg.rxctl_l );
		printf("Rx Status reg.\t\t0x%04x 0x%04x\n", reg.rxsta_u, reg.rxsta_l );
		printf("Rx Master Mode addr.\t0x%04x 0x%04x\n", reg.rxmar_u, reg.rxmar_l );
		printf("Rx Frame Preset cnt.\t0x%04x 0x%04x\n", reg.rxfpr_u, reg.rxfpr_l );
		printf("Rx Frame Count reg.\t0x%04x 0x%04x\n", reg.rxfcr_u, reg.rxfcr_l );
		printf("Rx FIFO Counter\t\t0x%04x 0x%04x\n", reg.rxcnt_u, reg.rxcnt_l );
	
		puts("");
		printf("System reg.\t\t0x%04x 0x%04x\n", reg.system_u, reg.system_l );

		puts("");
		printf("INT Control reg.\t0x%04x 0x%04x\n", reg.irctl_u, reg.irctl_l );
		printf("INT Status reg.\t\t0x%04x 0x%04x\n", reg.irsta_u, reg.irsta_l );
		printf("INT FIFO Counter\t0x%04x 0x%04x\n", reg.ircnt_u, reg.ircnt_l );

	return 0;

}

//----Show FIFO status
int CPCIreg::ShowFiFoStat()
{
	struct PCIREG reg;
	if ( dump_reg(&reg) ) return -1;

	
	return 0;
}
	
//----Clear FIFO
int CPCIreg::ClearFiFo()
{
	return clr_fifo();
}




