/* Check program */

#include <stdio.h>
#include <stdlib.h>
#include "Packet.h"
#include "ErrCode.h"
#include "ErrMsg.h"

#define FNAME	"4check_WR"
#define N_TM	20
#define REPEAT	1

#define BUF_SIZE	16000

int MyProc(int nArg);


//=======================================
int main(int argc, char *argv[])
{
	int nErr;
	int nArg = N_TM;

	//-----<argument>-----
	if ( argc==2 )	nArg = atoi(argv[1]);
	
	//-----<operation>-----
	nErr = MyProc(nArg);
	
	//-----<operation result>-----
	puts(FNAME);
	printf( pszErrString[nErr] );
	

//------Clear fifo
	while ( ::get_rxcnt() )
	{
		if ( ::clr_fifo() ) break;
		printf("\n...clearing fifo...\n");
	}


	return nErr;
}

//=======================================
int MyProc(int nArg)
{
	int nErr=0;

	CPacket pkt_WRScan(BUF_SIZE);
	
//==================<Command Frame Set>========================
	//-----WR-scan check----
//puts("W/R-scan Frames set!");
	unsigned long W;
	unsigned char wcnt=0;

for ( wcnt=0; wcnt<REPEAT; wcnt++ )
{
	for ( W=0x000001; W<0x1000000; W<<=1 )
	{
		if
		(
			pkt_WRScan.AddFrame(nArg,0,0x10,W)	||	//Set W 1bit by 1bit
			pkt_WRScan.AddFrame(nArg,0,0,0)		//Read R (written data read)
		)
		return 2;
	}
}

//puts("Cycle Go!");
	unsigned long er;
	if ( er=pkt_WRScan.Go(0) )
	{
		printf("er=%d\n",er);
		return 3;
	}
//==================<Comparison!>========================
unsigned long i;
unsigned long code, data;
unsigned long ErrAmount=0;
char szMsg[0xFF];

//-------
puts("W/R scan compare...");
	unsigned long R;
	for (W=0x000001, i=1; pkt_WRScan.ReadFrame(i,&code, &data)==0; W<<=1,i+=2 )
	{
		R = data & 0xffffff;
		memset( szMsg, 0x00, sizeof(szMsg) );
		sprintf( szMsg, "CHECK : W=0x%06x\n", W);
		sprintf( szMsg+strlen(szMsg), "%d\tREAD :\t0x%08x\t0x%08x\n", i, code, data);

		if ( W != R )
		{
			create_logfile(FNAME, szMsg);
			ErrAmount++;
		}
	}
//-------


	if ( ErrAmount )	return 4;
	
	return nErr;
}

