/* Check program */

#include <stdio.h>
#include <stdlib.h>
#include "ErrCode.h"
#include "ErrMsg.h"
#include "Packet.h"

#define FNAME	"0check_set"
#define N_TM	20
#define	REPEAT	1

#define BUF_SIZE	16000


//------function prototype------
int MyProc(int nArg);


//=======================================
int main(int argc, char *argv[])
{
	int nErr;
	int nArg = N_TM;

	//-----<argument>-----
	if ( argc==2 )	nArg = atoi(argv[1]);
	
	//-----<operation>-----
	nErr = MyProc(nArg);
	
	
	//-----<FIFO clear>-----
	while ( ::get_rxcnt() || ::get_ircnt() )
	{
		if ( ::clr_fifo() ) break;
		printf("\n...clearing fifo...\n");
	}


	//-----<operation result>-----
//	puts(FNAME);
//	printf( pszErrString[nErr] );
		
	return nErr;
}

//=======================================
int MyProc(int nArg)
{
	int nErr=0;
	
	//----self configuration----
	CPacket pkt_Conf(BUF_SIZE);
	
/*0*/	pkt_Conf.AddFrame(0x04);	//disable TRG-IN.

/*1*/	pkt_Conf.AddFrame(25,0,0x1a,0);	//set Inhibit
/*2*/	pkt_Conf.AddFrame(nArg, 0, 0x01,0);	//read dataway(dmy)
/*3*/	pkt_Conf.AddFrame(nArg, 0, 0x01,0);	//read dataway
	
/*4*/	pkt_Conf.AddFrame(25,0,0x18,0);	//remove Inhibit
/*5*/	pkt_Conf.AddFrame(nArg, 0, 0x01,0);	//read dataway(dmy)
/*6*/	pkt_Conf.AddFrame(nArg, 0, 0x01,0);	//read dataway
	
/*7*/	pkt_Conf.AddFrame(25,1,0x1a,0);	//enable INT.

	if ( nErr = pkt_Conf.Go(1) ) return nErr;


	//-----Data Compare-----
	unsigned long code, data;
	DATAWAYSTAT dway;
	char szMsg[0xFF];

	pkt_Conf.ReadFrame(3, &code, &data);
	DecTM(&dway, data);
	if ( dway.I!=1 )
	{
printf("code=0x%08X\tdata=0x%08X\n",code, data);
		memset(szMsg,0x00, sizeof(szMsg));
		sprintf(szMsg,"Inhibit is Not set!\n");
		create_logfile(FNAME, szMsg);
		nErr = ERR_INH;
	}
	
	pkt_Conf.ReadFrame(6, &code, &data);
	DecTM(&dway, data);
	if ( dway.I!=0 )
	{
printf("code=0x%08X\tdata=0x%08X\n",code, data);
		memset(szMsg,0x00, sizeof(szMsg));
		sprintf(szMsg,"Inhibit is Not removed!\n");
		create_logfile(FNAME, szMsg);
		nErr = ERR_INH;
	}

	pkt_Conf.ReadFrame(7, &code, &data);
	DecTM(&dway, data);
	if ( data & 0x10000000 !=0x10000000 )
	{
printf("code=0x%08X\tdata=0x%08X\n",code, data);
		memset(szMsg,0x00, sizeof(szMsg));
		sprintf(szMsg,"Enable INT. is Not set!\n");
		create_logfile(FNAME, szMsg);
		nErr = ERR_EINT;
	}
	

	return nErr;
}
